/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.goblintraders.datagen.TradeProvider;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.init.ModPotions;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.BasicTrade;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;

public class GoblinTradeProvider
extends TradeProvider {
    public GoblinTradeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void registerTrades() {
        this.registerGoblinTraderTrades();
        this.registerVeinGoblinTraderTrades();
    }

    private void registerGoblinTraderTrades() {
        EnchantmentData[] shovelEnchantments;
        EnchantmentData[] axeEnchantments;
        EnchantmentData[] pickaxeEnchantments;
        Item[] creeperMusicDiscs;
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151166_bC)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151034_e)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151042_j, 2)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221552_E)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151043_k, 3)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221551_D, 2)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151044_h)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151078_bh, 4)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151145_ak, 2)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221550_C)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151166_bC)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221585_m, 32)).setPriceMultiplier(0.0f).setMaxTrades(128).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151016_H, 2)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151166_bC, 6)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221943_hD)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151166_bC, 8)).setPaymentStack(new ItemStack((IItemProvider)Items.field_203795_aL)).setPriceMultiplier(0.0f).setMaxTrades(4).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_221646_ak)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC, 8)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_221846_eg)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221848_eh)).setSecondaryPaymentStack(new ItemStack((IItemProvider)Items.field_151042_j, 4)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_221844_ef)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221846_eg)).setSecondaryPaymentStack(new ItemStack((IItemProvider)Items.field_151042_j, 4)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_221894_fe, 2)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221776_cx)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151122_aG, 2)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151116_aA)).setSecondaryPaymentStack(new ItemStack((IItemProvider)Items.field_151121_aF, 3)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151062_by)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC, 3)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151057_cb)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC, 24)).setSecondaryPaymentStack(new ItemStack((IItemProvider)Items.field_151121_aF, 8)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_222047_ii)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221898_fg, 4)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(10).build());
        ItemStack luckOfTheSeaBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)Enchantments.field_151370_z, (Object)3), (ItemStack)luckOfTheSeaBook);
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151112_aM)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151112_aM)).setSecondaryPaymentStack(luckOfTheSeaBook).setPriceMultiplier(0.5f).setMaxTrades(2).setExperience(30).addEnchantment(new EnchantmentData(Enchantments.field_151370_z, 5)).build());
        ItemStack lureBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)Enchantments.field_151369_A, (Object)3), (ItemStack)lureBook);
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151112_aM)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151112_aM)).setSecondaryPaymentStack(lureBook).setPriceMultiplier(0.5f).setMaxTrades(2).setExperience(30).addEnchantment(new EnchantmentData(Enchantments.field_151369_A, 5)).build());
        for (Item disc : creeperMusicDiscs = new Item[]{Items.field_196158_dT, Items.field_196160_dU, Items.field_196162_dV, Items.field_196168_dY, Items.field_196170_dZ}) {
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)disc, 1)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC, 32)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(100).build());
        }
        for (EnchantmentData pickaxeEnchant : pickaxeEnchantments = new EnchantmentData[]{new EnchantmentData(Enchantments.field_185305_q, 5), new EnchantmentData(Enchantments.field_185307_s, 3), new EnchantmentData(Enchantments.field_185308_t, 3)}) {
            ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)pickaxeEnchant.field_76302_b, (Object)pickaxeEnchant.field_76303_c), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151046_w)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151046_w)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentData(pickaxeEnchant.field_76302_b, pickaxeEnchant.field_76303_c + 1)).build());
        }
        for (EnchantmentData axeEnchant : axeEnchantments = new EnchantmentData[]{new EnchantmentData(Enchantments.field_185305_q, 5), new EnchantmentData(Enchantments.field_185307_s, 3)}) {
            ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)axeEnchant.field_76302_b, (Object)axeEnchant.field_76303_c), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151056_x)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151056_x)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentData(axeEnchant.field_76302_b, axeEnchant.field_76303_c + 1)).build());
        }
        for (EnchantmentData shovelEnchant : shovelEnchantments = new EnchantmentData[]{new EnchantmentData(Enchantments.field_185305_q, 5), new EnchantmentData(Enchantments.field_185307_s, 3)}) {
            ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)shovelEnchant.field_76302_b, (Object)shovelEnchant.field_76303_c), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151047_v)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151047_v)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentData(shovelEnchant.field_76302_b, shovelEnchant.field_76303_c + 1)).build());
        }
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151046_w)).setPaymentStack(new ItemStack((IItemProvider)Items.field_196151_dA, 5)).setSecondaryPaymentStack(new ItemStack((IItemProvider)Items.field_151046_w)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(1000).addEnchantment(new EnchantmentData(Enchantments.field_185308_t, 5)).addEnchantment(new EnchantmentData(Enchantments.field_185307_s, 5)).build());
    }

    private void registerVeinGoblinTraderTrades() {
        Potion[] epicPotions;
        Potion[] rarePotions;
        EnchantmentData[] swordEnchantments;
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151166_bC)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151172_bF)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151114_aO, 4)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221695_cJ)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151166_bC, 1)).setPaymentStack(new ItemStack((IItemProvider)Items.field_221691_cH, 64)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151075_bm, 2)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC)).setPriceMultiplier(0.0f).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_190929_cY)).setPaymentStack(new ItemStack((IItemProvider)Items.field_234759_km_, 2)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_234760_kn_, 5)).setPaymentStack(new ItemStack((IItemProvider)Items.field_234795_rx_, 4)).setPriceMultiplier(0.0f).setMaxTrades(20).setExperience(50).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_221962_gm, 1)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151075_bm)).setSecondaryPaymentStack(new ItemStack((IItemProvider)Items.field_196154_dH)).setPriceMultiplier(0.0f).setMaxTrades(128).setExperience(4).build());
        for (EnchantmentData swordEnchant : swordEnchantments = new EnchantmentData[]{new EnchantmentData(Enchantments.field_185302_k, 5), new EnchantmentData(Enchantments.field_185304_p, 3), new EnchantmentData(Enchantments.field_191530_r, 3), new EnchantmentData(Enchantments.field_77334_n, 2), new EnchantmentData(Enchantments.field_180313_o, 2), new EnchantmentData(Enchantments.field_180312_n, 5), new EnchantmentData(Enchantments.field_185303_l, 5)}) {
            ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)swordEnchant.field_76302_b, (Object)swordEnchant.field_76303_c), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151048_u)).setPaymentStack(new ItemStack((IItemProvider)Items.field_151048_u)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentData(swordEnchant.field_76302_b, swordEnchant.field_76303_c + 1)).build());
        }
        Item[] diamondArmorSet = new Item[]{Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af};
        EnchantmentData[] armorEnchantments = new EnchantmentData[]{new EnchantmentData(Enchantments.field_185297_d, 4), new EnchantmentData(Enchantments.field_77329_d, 4), new EnchantmentData(Enchantments.field_180308_g, 4), new EnchantmentData(Enchantments.field_180310_c, 4), new EnchantmentData(Enchantments.field_185307_s, 3)};
        for (Item piece : diamondArmorSet) {
            for (EnchantmentData armorEnchant : armorEnchantments) {
                ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)armorEnchant.field_76302_b, (Object)armorEnchant.field_76303_c), (ItemStack)enchantedBook);
                this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)piece)).setPaymentStack(new ItemStack((IItemProvider)piece)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentData(armorEnchant.field_76302_b, armorEnchant.field_76303_c + 1)).build());
            }
        }
        for (Potion potion : rarePotions = new Potion[]{(Potion)ModPotions.EXTENDED_NIGHT_VISION.get(), (Potion)ModPotions.EXTENDED_INVISIBILITY.get(), (Potion)ModPotions.POWERFUL_JUMP_BOOST.get(), (Potion)ModPotions.EXTENDED_FIRE_RESISTANCE.get(), (Potion)ModPotions.POWERFUL_SPEED.get(), (Potion)ModPotions.EXTENDED_WATER_BREATHING.get(), (Potion)ModPotions.POWERFUL_INSTANT_HEALTH.get(), (Potion)ModPotions.POWERFUL_REGENERATION.get(), (Potion)ModPotions.EXTENDED_SLOW_FALLING.get()}) {
            ItemStack potionStack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)potion);
            ItemStack awkwardPotion = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)awkwardPotion, (Potion)Potions.field_185233_e);
            this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(potionStack).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC, 15)).setSecondaryPaymentStack(awkwardPotion).setPriceMultiplier(0.5f).setMaxTrades(8).setExperience(100).build());
        }
        for (Potion potion : epicPotions = new Potion[]{(Potion)ModPotions.HASTE.get(), (Potion)ModPotions.ABSORPTION.get(), (Potion)ModPotions.LEVITATION.get(), (Potion)ModPotions.LUCK.get(), (Potion)ModPotions.DOLPHINS_GRACE.get(), (Potion)ModPotions.POWERFUL_STRENGTH.get()}) {
            ItemStack potionStack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)potion);
            ItemStack awkwardPotion = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)awkwardPotion, (Potion)Potions.field_185233_e);
            this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(potionStack).setPaymentStack(new ItemStack((IItemProvider)Items.field_151166_bC, 25)).setSecondaryPaymentStack(awkwardPotion).setPriceMultiplier(0.5f).setMaxTrades(4).setExperience(100).build());
        }
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(new ItemStack((IItemProvider)Items.field_151048_u)).setPaymentStack(new ItemStack((IItemProvider)Items.field_196151_dA, 5)).setSecondaryPaymentStack(new ItemStack((IItemProvider)Items.field_151048_u)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(1000).addEnchantment(new EnchantmentData(Enchantments.field_185302_k, 7)).addEnchantment(new EnchantmentData(Enchantments.field_185307_s, 7)).build());
    }
}

